# Where To Look...

Min object examples by topic.

Most of the referenced example code is distributed as a part of the [Min-DevKit Package](https://github.com/Cycling74/min-devkit) unless otherwise specified.


## Attributes

* `min.xfade~` (enumerated list of symbol options with 'range' argument)
* `min.convolve` (vector/array attrs)


## Audio Sample Operators

* ease~` in the 

  [Ease Package]: https://github.com/Cycling74/ease/blob/master/source/projects/ease_tilde/ease_tilde.cpp

  

* `min.xfade~`


## Audio Vector Operators

* `buffer.index~`

* `filter.dcblock~` in the 

  [Filter Package]: https://github.com/Cycling74/filter/blob/master/source/projects/filter.dcblock_tilde/filter.dcblock_tilde.cpp


## Matrix Operators

* `min.jit.clamp`

* `min.jit.stencil`

* `jit.mo.func` in the 

  [Jit.Mo Package]: https://github.com/Cycling74/jit.mo/blob/master/source/projects/jit.mo.func/jit.mo.func.cpp


## Linking to Apple's Carbon Framework

* `min.project`


## Timers

* `min.beat.random`

* `zero.resolve` in the 

  [Zero Package]: https://github.com/Cycling74/zero/blob/master/source/projects/zero.resolve/zero.resolve.cpp

  

* `link.beat` (see the **Link** package)

* `min.note.make`


## Dictionaries

* `min.dict.join`
* `min.beat.pattern`


## Text Editors

* `min.function`


## Buffers

* `buffer.index~`


## State Saving

* `min.function`


## Class and Instance Creation Callbacks

* `jit.mo.func` (see the **jit.mo** package)


## Constructor Arguments

* `buffer.index~`
* `min.function`


## Library

* `min.beat.random` (uses random function)
* `filter.dcblock~` (uses dcblock filter unit) (see the **filter** package)


## More Advanced C++

* `min.xfade~` 
* most filters in the **Filter** package

## Using DLLs/Dylibs/Libraries from other 3rd-parties

* Link Package
* Sensel Package
