## Map Iterators





For a more intuitive way to work with maps I developed a `map_iterator` which which allows forward iteration of all maps. The syntax is held simple so that you can quickly go through a map as you can see in the following example:

### Example 

*Iterate through a maps's key/value pairs and prints them*

```
mm(mymap = "{a:1,b:2,c:3}")
map_iterator(${mymap})
ans(it)
while(true)
  map_iterator_break(it)
  # you have access to ${it.key} and ${it.value}
  message("${it.key} = ${it.value}")
endwhile()
```
*output*
```
a = 1
b = 2
c = 3
```

### Functions and Datatypes

* `<map iterator> ::= *internal data*` contains data which the iterator functions use.
* `<map iterator ref> ::= <iterator&>` a variable which contains an iterator
* `map_iterator(<map>): <map iterator>` creates a map iterator for the specied map
* `map_iterator_next(<iterator ref>):<bool>` returns true if the iterator could be advanced to the next key, also sets the variables `<iterator ref>.key` and `<iterator ref>.value` in the current scope
* `map_iterator_current(<iterator ref>):<value>` also sets `<iterator ref>.key` and `<iterator ref>.value` 
* `map_iterator_break(<iterator>)` only usable inside a loop (normally a while loop) it calls `break()` when the iterator has ended also sets `<iterator ref>.key` and `<iterator ref>.value` 


### Function List


* [map_iterator](#map_iterator)
* [map_iterator_break](#map_iterator_break)
* [map_iterator_next](#map_iterator_next)

### Function Descriptions

## <a name="map_iterator"></a> `map_iterator`

 initializes a new mapiterator




## <a name="map_iterator_break"></a> `map_iterator_break`





## <a name="map_iterator_next"></a> `map_iterator_next`

 this function moves the map iterator to the next position
 and returns true if it was possible
 e.g.
 map_iterator_next(myiterator) 
 ans(ok) ## is true if iterator had a next element
 variables ${myiterator.key} and ${myiterator.value} are available






