function(test)

function(yaml)
  # define callbacks for building result
  function(yaml_obj_begin)
   # message(PUSH_AFTER "yaml_obj_begin(${ARGN})")
    map_tryget(${context} indentation)
    ans(indentation)
    map_append_string(${context} yaml "{\n")
    map_append_string(${context} indentation " ")
  endfunction()
  function(yaml_obj_end)
    #message(POP "yaml_obj_end(${ARGN})")
    map_tryget(${context} indentation)
    ans(indentation)
    string(SUBSTRING "${indentation}" 1 -1 indentation)
    map_set(${context} indentation "${indentation}")
    map_append_string(${context} yaml "${indentation}}")

  endfunction()
  function(yaml_array_begin)
    #message(PUSH_AFTER "yaml_array_begin(${ARGN}) ${context}")
    map_tryget(${context} indentation)
    ans(indentation)
    map_append_string(${context} yaml "[\n")
    map_append_string(${context} indentation " ")
    
  endfunction()
  function(yaml_array_end)
   # message(POP "yaml_array_end(${ARGN}) ${context}")
    map_tryget(${context} indentation)
    ans(indentation)
    string(SUBSTRING "${indentation}" 1 -1 indentation)
    map_set(${context} indentation "${indentation}")
    map_append_string(${context} yaml "${indentation}]")
  endfunction()
  function(yaml_map_element_begin)
   # message("yaml_map_element_begin(${key} ${ARGN}) ${context}")
    map_tryget(${context} indentation)
    ans(indentation)
    map_append_string(${context} yaml "${indentation}\"${map_element_key}\":")
  endfunction()

  function(yaml_map_element_end)
    #message("yaml_map_element_end(${ARGN}) ${context}")
    math(EXPR comma "${map_length} - ${map_element_index} -1 ")
    if(comma)
      map_append_string(${context} yaml ",")
    endif()
    
    map_append_string(${context} yaml "\n")
  endfunction()

  function(yaml_list_element_begin)
   # message("yaml_list_element_begin(${ARGN}) ${context}")
    map_tryget(${context} indentation)
    ans(indentation)
    map_append_string(${context} yaml "${indentation}")
  endfunction()
  function(yaml_list_element_end)
   #message("yaml_list_element_end(${ARGN}) ${context}")
    math(EXPR comma "${list_length} - ${list_element_index} -1 ")
    if(comma)
      map_append_string(${context} yaml ",")
    endif()
    map_append_string(${context} yaml "\n")
  endfunction()
  function(yaml_literal)
    if(NOT content_length)
      map_append_string(${context} yaml "null")
    elseif("_${node}" MATCHES "^_(0|(([1-9][0-9]*)([.][0-9]+([eE][+-]?[0-9]+)?)?)|true|false)$")
      map_append_string(${context} yaml "${node}")
    else()
      cmake_string_to_json("${node}")
      ans(node)
      map_append_string(${context} yaml "${node}")
    endif()
    return()
  endfunction()

   map()
    kv(value              yaml_literal)
    kv(map_begin          yaml_obj_begin)
    kv(map_end            yaml_obj_end)
    kv(list_begin         yaml_array_begin)
    kv(list_end           yaml_array_end)
    kv(map_element_begin  yaml_map_element_begin)
    kv(map_element_end    yaml_map_element_end)
    kv(list_element_begin yaml_list_element_begin)
    kv(list_element_end   yaml_list_element_end)
  end()
  ans(yaml_callbacks)
  function_import_table(${yaml_callbacks} yaml_callback)

  # function definition
  function(yaml)        
    map_new()
    ans(context)
    dfs_callback(yaml_callback ${ARGN})
    map_tryget(${context} yaml)
    return_ans()  
  endfunction()
  #delegate
  yaml(${ARGN})
  return_ans()
endfunction()


function(yaml_data)
   data(${ARGN})
   ans(data)
   yaml(${data})
   ans(serialized)
   return_ref(serialized)
endfunction()


yaml_data("{id:1}")
message("${__ans}")

endfunction()