
function(cmake_token_range_targets_filter range target_name)
  cmake_token_range("${range}")
  ans(range)
  cmake_invocation_filter_token_range("${range}" 
    invocation_identifier MATCHES "^(add_custom_target)|(add_test)|(add_library)|(add_executable)|(target_link_libraries)|(target_include_directories)|(target_compile_options)|(target_compile_definitions)$" 
    AND invocation_arguments MATCHES "^${target_name}(;|$)"
    )
  ans(target_invocations)
  map_new()
  ans(targets)

  set(target_definition_invocation)
  set(target_include_directories_invocation)
  set(target_link_libraries_invocation)
  set(target_compile_definitions_invocation)
  set(target_compile_options_invocation)
  foreach(target_invocation ${target_invocations})
    map_tryget(${target_invocation} invocation_arguments)
    ans_extract(target_name)
    ans(values)
    map_tryget(${targets} ${target_name})
    ans(target)
    if(NOT target)
      map_new()
      ans(target)
      map_new()
      ans(target_invocations)
      map_set_hidden(${target} target_invocations ${target_invocations})
      map_set(${targets} ${target_name} ${target})
      map_set(${target} target_name ${target_name})
    else()
      map_tryget(${target} target_invocations)
      ans(target_invocations)
    endif()

    map_tryget(${target_invocation} invocation_identifier)
    ans(invocation_identifier)

    if("${invocation_identifier}" MATCHES "^add_(.+)$")
      set(type target_source_files)
      map_set(${target} target_type ${CMAKE_MATCH_1})
    elseif("${invocation_identifier}" STREQUAL "target_link_libraries")
      set(type target_link_libraries)      
    elseif("${invocation_identifier}" STREQUAL "target_include_directories")
      set(type target_include_directories)      
    elseif("${invocation_identifier}" STREQUAL "target_compile_options")
      set(type target_compile_options)      
    elseif("${invocation_identifier}" STREQUAL "target_compile_definitions")
      set(type target_compile_definitions)      
    endif()
    map_set(${target} ${type} ${values})
    map_set(${target_invocations} "${type}" ${target_invocation} )
  endforeach()
  return_ref(targets)
endfunction()