# creates a union from all all maps passed as ARGN and combines them in the first
# you can merge two maps by typing map_union(${map1} ${map1} ${map2})
# maps are merged in order ( the last one takes precedence)
function(map_union)
	set(lst ${ARGN})
	list_pop_front(lst)
	ans(res)
	if(NOT res)
		message(FATAL_ERROR "map_union: no maps passed")
	endif()
	# loop through the keys of every map	
	foreach(map ${lst})
		map_keys(${map} )
		ans(keys)
		foreach(key ${keys})
			map_tryget(${map}  ${key})
			ans(val)
			map_set(${res} ${key} ${val})
		endforeach()
	endforeach()
	return(${res})
endfunction()

