# EXtrack
function(markdown_template_function_descriptions)
  string(REPLACE "\;" ";" files "${ARGN}")
  set(res)
  foreach(template_path ${files})
    fread("${template_path}")
    ans(content)
    cmake_script_comment_header("${content}")
    ans(comments)
    cmake_script_parse("${content}" --first-function-header)
    ans(function_def)
    assign(function_name = function_def.function_args[0])
    if(NOT "${function_name}_" STREQUAL "_")
      get_filename_component(template_dir "${template_path}" PATH)
      pushd("${template_dir}")
      template_run("${comments}")
      ans(comments)
      popd()
      set(res
          "${res}## <a name=\"${function_name}\"></a> `${function_name}`\n\n${comments}\n\n\n\n"
      )
    endif()
  endforeach()
  return_ref(res)
endfunction()
