# parses a git ref and retruns a map with the fields type and name
function(git_ref_parse  ref)
  set(res)
  if(${ref} STREQUAL HEAD)
    map_new()
    ans(res)
    map_set(${res} type HEAD)
    map_set(${res} name HEAD)
  endif()
  if("${ref}" MATCHES "^refs/([^/]*)/(.*)$")
    string(REGEX REPLACE "^refs/([^/]*)/(.*)$" "\\1;\\2" parts "${ref}")
    list_extract(parts type name)
    map_new()
    ans(res)
    map_set(${res} type ${type})
    map_set(${res} name ${name})
  endif()
  return_ref(res)
endfunction()