function(test)


function(ref_nav_get current_value)
  set(expression ${ARGN})
  if("${expression}" MATCHES "^&(.*)")
    message(FATAL_ERROR "address operation is unsupported")
  elseif("${expression}" MATCHES "^%(.*)")
    set(return_lvalue true )
    set(expression "${CMAKE_MATCH_1}")
  else()
    set(return_lvalue false)
  endif()

  navigation_expression_parse("${expression}")
  ans(expression)

  set(current_ref)
  set(current_property)
  set(current_ranges)
  foreach(current_expression ${expression})
    if("${current_expression}" MATCHES "^[<>].*[<>]$")
      list_range_try_get(current_value "${current_expression}")
      ans(current_value)
      list(APPEND current_ranges ${current_expression})
    else()
      set(current_ref)
      set(current_result_value)
      foreach(current_value_i ${current_value})
        is_address("${current_value_i}")
        ans(is_ref)
        if(is_ref)
          list(APPEND current_ref "${current_value_i}")
          #set(current_ref "${current_value}")
          set(current_property "${current_expression}")
          set(current_ranges)
          ref_prop_get("${current_value_i}" "${current_expression}")
          list(APPEND current_result_value ${__ans})
        endif()
      endforeach()
      set(current_value "${current_result_value}")
      if("${current_value}_" STREQUAL "_")
        break()
      endif()
    endif()
  endforeach()
  if(return_lvalue)
    map_capture_new(ref:current_ref property:current_property range:current_ranges value:current_value --reassign)
    return_ans()    
  endif()


  return_ref(current_value)

endfunction()

  
  function(test_ref_nav_get  current_value expression)
   # message("expression: ${expression}")
    data("${current_value}")
    ans(current_value)
    ref_nav_get("${current_value}" "${expression}")
    ans(res)
    #json_print(${res})
    #message(" \n")
    return_ref(res)
  endfunction()

  define_test_function(test_uut test_ref_nav_get current_value expression)
  
  test_uut("{ref:null,property:null,value:null,range:null}" "" "%")
  test_uut("{ref:null,property:null,value:123,range:null}" "123" "%")
  test_uut("{ref:null,property:null,value:123,range:'<0>'}" "123" "%[0]")
  test_uut("{ref:{a:123},property:'a',value:123,range:null}" "{a:123}" "%a")
  test_uut("{ref:{a:[123,234,345]},property:'a',value:234,range:'<1>'}" "{a:[123,234,345]}" "%a[1]")
  test_uut("1;2;3" "[{a:1},{a:2},{a:3}]" "[:].a" )
  test_uut("2;3" "[{a:1},{a:2},{a:3}]" "[:].a[1:2]" )


endfunction()