function(test)
  set(res "")
  # Test if linked list is a,b,c (manual way)
  set(input "abc")
  string_split_parts("${input}" 1)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "a")
  map_tryget("${res}" next)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "b")
  map_tryget("${res}" next)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "c")

  set(res "")
  # Test if linked list is ab,c (manual way)
  set(input "abc")
  string_split_parts("${input}" 2)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "ab")
  map_tryget("${res}" next)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "c")

  set(res "")
  # Test if linked list is abc (manual way)
  set(input "abc")
  string_split_parts("${input}" 3)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "abc")

  set(res "")
  # Length is bigger than input string
  set(input "abc")
  string_split_parts("${input}" 4)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}" STREQUAL "abc")

  set(res "")
  # Length is 0
  set(input "abc")
  string_split_parts("${input}" 0)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}_" STREQUAL "_")

  set(res "")
  # Length is negative
  set(input "abc")
  string_split_parts("${input}" -1)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}_" STREQUAL "_")

  set(res "")
  # Input is empty
  set(input "")
  string_split_parts("${input}" 1)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}_" STREQUAL "_")

  set(res "")
  # Input is empty, index is 0
  set(input "")
  string_split_parts("${input}" 0)
  ans(res)
  address_get("${res}")
  ans(data)
  assert("${data}_" STREQUAL "_")
endfunction()