/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.ClassInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.LocalVariableInfo;
import jode.bytecode.MethodInfo;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.ClassDeclarer;
import jode.decompiler.DeadCodeAnalysis;
import jode.decompiler.Declarable;
import jode.decompiler.ImportHandler;
import jode.decompiler.LocalInfo;
import jode.decompiler.LocalVarEntry;
import jode.decompiler.LocalVariableTable;
import jode.decompiler.Opcodes;
import jode.decompiler.Options;
import jode.decompiler.OuterValues;
import jode.decompiler.ProgressListener;
import jode.decompiler.Scope;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CheckNullOperator;
import jode.expr.Expression;
import jode.expr.InvokeOperator;
import jode.expr.LocalLoadOperator;
import jode.expr.OuterLocalOperator;
import jode.expr.ThisOperator;
import jode.flow.EmptyBlock;
import jode.flow.FlowBlock;
import jode.flow.Jump;
import jode.flow.StructuredBlock;
import jode.flow.TransformExceptionHandlers;
import jode.jvm.CodeVerifier;
import jode.jvm.SyntheticAnalyzer;
import jode.jvm.VerifyException;
import jode.type.MethodType;
import jode.type.Type;

public class MethodAnalyzer
implements Scope,
ClassDeclarer {
    private static double STEP_COMPLEXITY = 0.01;
    private static int STRICTFP = 2048;
    ImportHandler imports;
    ClassAnalyzer classAnalyzer;
    MethodInfo minfo;
    BytecodeInfo code;
    String methodName;
    MethodType methodType;
    boolean isConstructor;
    Type[] exceptions;
    SyntheticAnalyzer synth;
    FlowBlock methodHeader;
    Vector allLocals = new Vector();
    LocalInfo[] param;
    LocalVariableTable lvt;
    MethodAnalyzer jikesConstructor;
    boolean hasJikesOuterValue;
    boolean isAnonymousConstructor;
    boolean isJikesBlockInitializer;
    Vector anonConstructors = new Vector();
    Vector innerAnalyzers;
    Collection usedAnalyzers;

    public String getName() {
        return this.methodName;
    }

    public MethodType getType() {
        return this.methodType;
    }

    public FlowBlock getMethodHeader() {
        return this.methodHeader;
    }

    public final BytecodeInfo getBytecodeInfo() {
        return this.code;
    }

    public final ImportHandler getImportHandler() {
        return this.imports;
    }

    public final void useType(Type type) {
        this.imports.useType(type);
    }

    public void insertStructuredBlock(StructuredBlock structuredBlock) {
        if (this.methodHeader == null) {
            throw new IllegalStateException();
        }
        structuredBlock.setJump(new Jump(FlowBlock.NEXT_BY_ADDR));
        FlowBlock flowBlock = new FlowBlock(this, 0);
        flowBlock.appendBlock(structuredBlock, 0);
        flowBlock.setNextByAddr(this.methodHeader);
        flowBlock.doT2(this.methodHeader);
        this.methodHeader = flowBlock;
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public final boolean isStatic() {
        return this.minfo.isStatic();
    }

    public final boolean isSynthetic() {
        return this.minfo.isSynthetic();
    }

    public final boolean isStrictFP() {
        return (this.minfo.getModifiers() & STRICTFP) != 0;
    }

    public final void setJikesConstructor(MethodAnalyzer methodAnalyzer) {
        this.jikesConstructor = methodAnalyzer;
    }

    public final void setJikesBlockInitializer(boolean bl) {
        this.isJikesBlockInitializer = bl;
    }

    public final void setHasOuterValue(boolean bl) {
        this.hasJikesOuterValue = bl;
    }

    public final void setAnonymousConstructor(boolean bl) {
        this.isAnonymousConstructor = bl;
    }

    public final boolean isAnonymousConstructor() {
        return this.isAnonymousConstructor;
    }

    public final SyntheticAnalyzer getSynthetic() {
        return this.synth;
    }

    public Type getReturnType() {
        return this.methodType.getReturnType();
    }

    public ClassAnalyzer getClassAnalyzer() {
        return this.classAnalyzer;
    }

    public ClassInfo getClazz() {
        return this.classAnalyzer.clazz;
    }

    public final LocalInfo getParamInfo(int n) {
        return this.param[n];
    }

    public final int getParamCount() {
        return this.param.length;
    }

    public LocalInfo getLocalInfo(int n, int n2) {
        LocalVarEntry localVarEntry;
        LocalInfo localInfo = new LocalInfo(this, n2);
        if (this.lvt != null && (localVarEntry = this.lvt.getLocal(n2, n)) != null) {
            localInfo.addHint(localVarEntry.getName(), localVarEntry.getType());
        }
        this.allLocals.addElement(localInfo);
        return localInfo;
    }

    public double getComplexity() {
        if (this.code == null) {
            return 0.0;
        }
        return this.code.getInstructions().size();
    }

    private void analyzeCode(ProgressListener progressListener, double d, double d2) {
        Object object;
        Object object2;
        Instruction instruction;
        int n = Integer.MAX_VALUE;
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.print(this.methodName + ": ");
        }
        if (progressListener != null) {
            n = (int)((double)this.code.getInstructions().size() * STEP_COMPLEXITY / (d2 * 0.9));
        }
        DeadCodeAnalysis.removeDeadCode(this.code);
        Handler[] handlerArray = this.code.getExceptionHandlers();
        Iterator iterator = this.code.getInstructions().iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (instruction.getPrevByAddr() != null && !instruction.getPrevByAddr().doesAlwaysJump() && instruction.getPreds() == null) continue;
            instruction.setTmpInfo(new FlowBlock(this, instruction.getAddr()));
        }
        int n2 = 0;
        while (n2 < handlerArray.length) {
            instruction = handlerArray[n2].start;
            if (instruction.getTmpInfo() == null) {
                instruction.setTmpInfo(new FlowBlock(this, instruction.getAddr()));
            }
            if ((instruction = handlerArray[n2].end.getNextByAddr()).getTmpInfo() == null) {
                instruction.setTmpInfo(new FlowBlock(this, instruction.getAddr()));
            }
            if ((instruction = handlerArray[n2].catcher).getTmpInfo() == null) {
                instruction.setTmpInfo(new FlowBlock(this, instruction.getAddr()));
            }
            ++n2;
        }
        n2 = 1000;
        int n3 = 0;
        FlowBlock flowBlock = null;
        boolean bl = false;
        Iterator iterator2 = this.code.getInstructions().iterator();
        while (iterator2.hasNext()) {
            object2 = (Instruction)iterator2.next();
            object = Opcodes.readOpcode((Instruction)object2, this);
            if (GlobalOptions.verboseLevel > 0 && ((Instruction)object2).getAddr() > n2) {
                GlobalOptions.err.print('.');
                n2 += 1000;
            }
            if (++n3 >= n) {
                progressListener.updateProgress(d += (double)n3 * d2 / (double)this.code.getInstructions().size(), this.methodName);
                n3 = 0;
            }
            if (bl && ((Instruction)object2).getTmpInfo() == null && !((Instruction)object2).doesAlwaysJump() && ((Instruction)object2).getSuccs() == null) {
                flowBlock.appendBlock((StructuredBlock)object, ((Instruction)object2).getLength());
                continue;
            }
            if (((Instruction)object2).getTmpInfo() == null) {
                ((Instruction)object2).setTmpInfo(new FlowBlock(this, ((Instruction)object2).getAddr()));
            }
            FlowBlock flowBlock2 = (FlowBlock)((Instruction)object2).getTmpInfo();
            flowBlock2.appendBlock((StructuredBlock)object, ((Instruction)object2).getLength());
            if (flowBlock != null) {
                flowBlock.setNextByAddr(flowBlock2);
            }
            flowBlock = flowBlock2;
            ((Instruction)object2).setTmpInfo(flowBlock);
            boolean bl2 = bl = !((Instruction)object2).doesAlwaysJump() && ((Instruction)object2).getSuccs() == null;
        }
        this.methodHeader = (FlowBlock)((Instruction)this.code.getInstructions().get(0)).getTmpInfo();
        TransformExceptionHandlers transformExceptionHandlers = new TransformExceptionHandlers();
        int n4 = 0;
        while (n4 < handlerArray.length) {
            object2 = null;
            object = (FlowBlock)handlerArray[n4].start.getTmpInfo();
            int n5 = handlerArray[n4].end.getNextByAddr().getAddr();
            FlowBlock flowBlock3 = (FlowBlock)handlerArray[n4].catcher.getTmpInfo();
            if (handlerArray[n4].type != null) {
                object2 = Type.tClass(handlerArray[n4].type);
            }
            transformExceptionHandlers.addHandler((FlowBlock)object, n5, flowBlock3, (Type)object2);
            ++n4;
        }
        Iterator iterator3 = this.code.getInstructions().iterator();
        while (iterator3.hasNext()) {
            Instruction instruction2 = (Instruction)iterator3.next();
            instruction2.setTmpInfo(null);
        }
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.print('-');
        }
        transformExceptionHandlers.analyze();
        this.methodHeader.analyze();
        if ((Options.options & 8) == 0 && this.methodHeader.mapStackToLocal()) {
            this.methodHeader.removePush();
        }
        if ((Options.options & 0x40) != 0) {
            this.methodHeader.removeOnetimeLocals();
        }
        this.methodHeader.mergeParams(this.param);
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.println("");
        }
        if (progressListener != null) {
            progressListener.updateProgress(d += 0.1 * d2, this.methodName);
        }
    }

    public void analyze(ProgressListener progressListener, double d, double d2) throws ClassFormatError {
        Object object;
        if (progressListener != null) {
            progressListener.updateProgress(d, this.methodName);
        }
        if (this.code != null) {
            if ((Options.options & 0x100) != 0) {
                object = new CodeVerifier(this.getClazz(), this.minfo, this.code);
                try {
                    ((CodeVerifier)object).verify();
                }
                catch (VerifyException verifyException) {
                    verifyException.printStackTrace(GlobalOptions.err);
                    throw new AssertError("Verification error");
                }
            }
            if ((Options.options & 1) != 0 && (object = this.code.getLocalVariableTable()) != null) {
                this.lvt = new LocalVariableTable(this.code.getMaxLocals(), (LocalVariableInfo[])object);
            }
        }
        object = this.getType().getParameterTypes();
        int n = (this.isStatic() ? 0 : 1) + ((Type[])object).length;
        this.param = new LocalInfo[n];
        int n2 = 0;
        int n3 = 0;
        if (!this.isStatic()) {
            ClassInfo classInfo = this.classAnalyzer.getClazz();
            LocalInfo localInfo = this.getLocalInfo(0, n3++);
            localInfo.setExpression(new ThisOperator(classInfo, true));
            this.param[n2++] = localInfo;
        }
        int n4 = 0;
        while (n4 < ((Object)object).length) {
            this.param[n2] = this.getLocalInfo(0, n3);
            this.param[n2].setType((Type)object[n4]);
            n3 += ((Type)object[n4]).stackSize();
            ++n2;
            ++n4;
        }
        n4 = 0;
        while (n4 < this.exceptions.length) {
            this.imports.useType(this.exceptions[n4]);
            ++n4;
        }
        if (!this.isConstructor) {
            this.imports.useType(this.methodType.getReturnType());
        }
        if (this.code != null) {
            this.analyzeCode(progressListener, d, d2);
        }
    }

    public void analyzeInnerClasses() throws ClassFormatError {
        boolean bl = false;
        Enumeration enumeration = this.anonConstructors.elements();
        while (enumeration.hasMoreElements()) {
            InvokeOperator invokeOperator = (InvokeOperator)enumeration.nextElement();
            this.analyzeInvokeOperator(invokeOperator);
        }
    }

    public void makeDeclaration(Set set) {
        Object object;
        Object object2;
        Enumeration enumeration;
        if (this.innerAnalyzers != null) {
            enumeration = this.innerAnalyzers.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (ClassAnalyzer)enumeration.nextElement();
                if (((ClassAnalyzer)object2).getParent() != this) continue;
                object = ((ClassAnalyzer)object2).getOuterValues();
                int n = 0;
                while (n < ((OuterValues)object).getCount()) {
                    LocalInfo localInfo;
                    Expression expression = ((OuterValues)object).getValue(n);
                    if (expression instanceof OuterLocalOperator && (localInfo = ((OuterLocalOperator)expression).getLocalInfo()).getMethodAnalyzer() == this) {
                        localInfo.markFinal();
                    }
                    ++n;
                }
            }
        }
        enumeration = this.allLocals.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (LocalInfo)enumeration.nextElement();
            if (((LocalInfo)object2).isShadow()) continue;
            this.imports.useType(((LocalInfo)object2).getType());
        }
        int n = 0;
        while (n < this.param.length) {
            this.param[n].guessName();
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Declarable)object2.next();
                if (!this.param[n].getName().equals(object.getName())) continue;
                this.param[n].makeNameUnique();
                break;
            }
            set.add(this.param[n]);
            ++n;
        }
        if (this.code != null) {
            this.methodHeader.makeDeclaration(set);
            this.methodHeader.simplify();
        }
        n = 0;
        while (n < this.param.length) {
            set.remove(this.param[n]);
            ++n;
        }
    }

    public boolean skipWriting() {
        if (this.synth != null) {
            if (this.synth.getKind() == 1) {
                return true;
            }
            if (this.synth.getKind() >= 2 && this.synth.getKind() <= 10 && (Options.options & 2) != 0 && (Options.options & 4) != 0) {
                return true;
            }
        }
        if (this.jikesConstructor == this) {
            return true;
        }
        boolean bl = this.isConstructor;
        int n = 0;
        if (this.isConstructor() && !this.isStatic() && this.classAnalyzer.outerValues != null) {
            n = this.classAnalyzer.outerValues.getCount();
        }
        if (this.jikesConstructor != null) {
            bl = true;
            int n2 = n = this.hasJikesOuterValue && this.classAnalyzer.outerValues.getCount() > 0 ? 1 : 0;
        }
        if (this.isJikesBlockInitializer) {
            return true;
        }
        if (this.getMethodHeader() == null || !(this.getMethodHeader().getBlock() instanceof EmptyBlock) || !this.getMethodHeader().hasNoJumps() || this.exceptions.length > 0) {
            return false;
        }
        if (bl && ((this.minfo.getModifiers() & 0x52F) == (this.getClassAnalyzer().getModifiers() & 5) || this.classAnalyzer.getName() == null) && this.classAnalyzer.constructors.length == 1 && (this.methodType.getParameterTypes().length == n || this.isAnonymousConstructor)) {
            return true;
        }
        return this.isConstructor() && this.isStatic();
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        int n;
        String string;
        boolean bl = this.isConstructor;
        int n2 = 0;
        int n3 = this.minfo.getModifiers();
        if (this.isConstructor() && !this.isStatic() && (Options.options & 0x200) != 0 && this.classAnalyzer.outerValues != null) {
            n2 = this.classAnalyzer.outerValues.getCount();
        }
        if (this.jikesConstructor != null) {
            bl = true;
            n2 = this.hasJikesOuterValue && this.classAnalyzer.outerValues.getCount() > 0 ? 1 : 0;
            n3 = this.jikesConstructor.minfo.getModifiers();
        }
        if (this.minfo.isDeprecated()) {
            tabbedPrintWriter.println("/**");
            tabbedPrintWriter.println(" * @deprecated");
            tabbedPrintWriter.println(" */");
        }
        tabbedPrintWriter.pushScope(this);
        if (this.classAnalyzer.getClazz().isInterface()) {
            n3 &= 0xFFFFFBFF;
        }
        if (this.isConstructor() && this.isStatic()) {
            n3 &= 0xFFFFFFE8;
        }
        n3 &= ~STRICTFP;
        tabbedPrintWriter.startOp(1, 1);
        String string2 = "";
        if (this.minfo.isSynthetic()) {
            tabbedPrintWriter.print("/*synthetic*/");
            string2 = " ";
        }
        if ((string = Modifier.toString(n3)).length() > 0) {
            tabbedPrintWriter.print(string2 + string);
            string2 = " ";
        }
        if (this.isStrictFP() && !this.classAnalyzer.isStrictFP() && !this.isConstructor() && (n3 & 0x100) == 0) {
            tabbedPrintWriter.print(string2 + "strictfp");
            string2 = " ";
        }
        if (!this.isConstructor || !this.isStatic() && (this.classAnalyzer.getName() != null || n2 != this.methodType.getParameterTypes().length)) {
            tabbedPrintWriter.print(string2);
            if (bl) {
                tabbedPrintWriter.print(this.classAnalyzer.getName());
            } else {
                tabbedPrintWriter.printType(this.getReturnType());
                tabbedPrintWriter.print(" " + this.methodName);
            }
            tabbedPrintWriter.breakOp();
            if ((Options.outputStyle & 0x40) != 0) {
                tabbedPrintWriter.print(" ");
            }
            tabbedPrintWriter.print("(");
            tabbedPrintWriter.startOp(0, 0);
            int n4 = n = n2 + (this.isStatic() ? 0 : 1);
            while (n4 < this.param.length) {
                if (n4 > n) {
                    tabbedPrintWriter.print(", ");
                    tabbedPrintWriter.breakOp();
                }
                this.param[n4].dumpDeclaration(tabbedPrintWriter);
                ++n4;
            }
            tabbedPrintWriter.endOp();
            tabbedPrintWriter.print(")");
        }
        if (this.exceptions.length > 0) {
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" throws ");
            tabbedPrintWriter.startOp(0, 2);
            n = 0;
            while (n < this.exceptions.length) {
                if (n > 0) {
                    tabbedPrintWriter.print(",");
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(" ");
                }
                tabbedPrintWriter.printType(this.exceptions[n]);
                ++n;
            }
            tabbedPrintWriter.endOp();
        }
        tabbedPrintWriter.endOp();
        if (this.code != null) {
            tabbedPrintWriter.openBraceNoIndent();
            tabbedPrintWriter.tab();
            this.methodHeader.dumpSource(tabbedPrintWriter);
            tabbedPrintWriter.untab();
            tabbedPrintWriter.closeBraceNoIndent();
        } else {
            tabbedPrintWriter.println(";");
        }
        tabbedPrintWriter.popScope();
    }

    public LocalInfo findLocal(String string) {
        Enumeration enumeration = this.allLocals.elements();
        while (enumeration.hasMoreElements()) {
            LocalInfo localInfo = (LocalInfo)enumeration.nextElement();
            if (!localInfo.getName().equals(string)) continue;
            return localInfo;
        }
        return null;
    }

    public ClassAnalyzer findAnonClass(String string) {
        if (this.innerAnalyzers != null) {
            Enumeration enumeration = this.innerAnalyzers.elements();
            while (enumeration.hasMoreElements()) {
                ClassAnalyzer classAnalyzer = (ClassAnalyzer)enumeration.nextElement();
                if (classAnalyzer.getParent() != this || classAnalyzer.getName() == null || !classAnalyzer.getName().equals(string)) continue;
                return classAnalyzer;
            }
        }
        return null;
    }

    public boolean isScopeOf(Object object, int n) {
        ClassAnalyzer classAnalyzer;
        if (n == 2 && object instanceof ClassInfo && (classAnalyzer = this.getClassAnalyzer((ClassInfo)object)) != null) {
            return classAnalyzer.getParent() == this;
        }
        return false;
    }

    public boolean conflicts(String string, int n) {
        if (n == 4 || n == 5) {
            return this.findLocal(string) != null;
        }
        if (n == 4 || n == 1) {
            return this.findAnonClass(string) != null;
        }
        return false;
    }

    public ClassDeclarer getParent() {
        return this.getClassAnalyzer();
    }

    public void addAnonymousConstructor(InvokeOperator invokeOperator) {
        this.anonConstructors.addElement(invokeOperator);
    }

    public void analyzeInvokeOperator(InvokeOperator invokeOperator) {
        ClassAnalyzer classAnalyzer;
        block15: {
            block14: {
                ClassInfo classInfo = invokeOperator.getClassInfo();
                classAnalyzer = this.getParent().getClassAnalyzer(classInfo);
                if (classAnalyzer != null) break block14;
                Expression[] expressionArray = invokeOperator.getSubExpressions();
                Expression[] expressionArray2 = new Expression[expressionArray.length - 1];
                int n = 0;
                while (n < expressionArray2.length) {
                    Expression expression = expressionArray[n + 1].simplify();
                    if (expression instanceof CheckNullOperator) {
                        expression = ((CheckNullOperator)expression).getSubExpressions()[0];
                    }
                    if (expression instanceof ThisOperator) {
                        expressionArray2[n] = new ThisOperator(((ThisOperator)expression).getClassInfo());
                    } else {
                        LocalInfo localInfo = null;
                        if (expression instanceof LocalLoadOperator && !(localInfo = ((LocalLoadOperator)expression).getLocalInfo()).isConstant()) {
                            localInfo = null;
                        }
                        if (expression instanceof OuterLocalOperator) {
                            localInfo = ((OuterLocalOperator)expression).getLocalInfo();
                        }
                        if (localInfo != null) {
                            expressionArray2[n] = new OuterLocalOperator(localInfo);
                        } else {
                            Expression[] expressionArray3 = new Expression[n];
                            System.arraycopy(expressionArray2, 0, expressionArray3, 0, n);
                            expressionArray2 = expressionArray3;
                            break;
                        }
                    }
                    ++n;
                }
                classAnalyzer = new ClassAnalyzer(this, classInfo, this.imports, expressionArray2);
                this.addClassAnalyzer(classAnalyzer);
                classAnalyzer.initialize();
                classAnalyzer.analyze(null, 0.0, 0.0);
                classAnalyzer.analyzeInnerClasses(null, 0.0, 0.0);
                break block15;
            }
            OuterValues outerValues = classAnalyzer.getOuterValues();
            Expression[] expressionArray = invokeOperator.getSubExpressions();
            int n = 0;
            while (n < outerValues.getCount()) {
                block17: {
                    block16: {
                        if (n + 1 >= expressionArray.length) break block16;
                        Expression expression = expressionArray[n + 1].simplify();
                        if (expression instanceof CheckNullOperator) {
                            expression = ((CheckNullOperator)expression).getSubExpressions()[0];
                        }
                        if (outerValues.unifyOuterValues(n, expression)) break block17;
                    }
                    outerValues.setCount(n);
                    break;
                }
                ++n;
            }
        }
        if (this.usedAnalyzers == null) {
            this.usedAnalyzers = new ArrayList();
        }
        this.usedAnalyzers.add(classAnalyzer);
    }

    public ClassAnalyzer getClassAnalyzer(ClassInfo classInfo) {
        if (this.innerAnalyzers != null) {
            Enumeration enumeration = this.innerAnalyzers.elements();
            while (enumeration.hasMoreElements()) {
                ClassAnalyzer classAnalyzer = (ClassAnalyzer)enumeration.nextElement();
                if (!classAnalyzer.getClazz().equals(classInfo)) continue;
                if (classAnalyzer.getParent() != this) {
                    ClassDeclarer classDeclarer = classAnalyzer.getParent();
                    while (classDeclarer != this) {
                        if (classDeclarer instanceof MethodAnalyzer) {
                            ((MethodAnalyzer)classDeclarer).innerAnalyzers.removeElement(classAnalyzer);
                        }
                        classDeclarer = classDeclarer.getParent();
                    }
                    classAnalyzer.setParent(this);
                }
                return classAnalyzer;
            }
        }
        return this.getParent().getClassAnalyzer(classInfo);
    }

    public void addClassAnalyzer(ClassAnalyzer classAnalyzer) {
        if (this.innerAnalyzers == null) {
            this.innerAnalyzers = new Vector();
        }
        this.innerAnalyzers.addElement(classAnalyzer);
        this.getParent().addClassAnalyzer(classAnalyzer);
    }

    public void fillDeclarables(Collection collection) {
        if (this.usedAnalyzers != null) {
            collection.addAll(this.usedAnalyzers);
        }
        if (this.innerAnalyzers != null) {
            Enumeration enumeration = this.innerAnalyzers.elements();
            while (enumeration.hasMoreElements()) {
                ClassAnalyzer classAnalyzer = (ClassAnalyzer)enumeration.nextElement();
                if (classAnalyzer.getParent() != this) continue;
                classAnalyzer.fillDeclarables(collection);
            }
        }
    }

    public boolean isMoreOuterThan(ClassDeclarer classDeclarer) {
        ClassDeclarer classDeclarer2 = classDeclarer;
        while (classDeclarer2 != null) {
            if (classDeclarer2 == this) {
                return true;
            }
            classDeclarer2 = classDeclarer2.getParent();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getClazz() + "." + this.getName() + "]";
    }

    public MethodAnalyzer(ClassAnalyzer classAnalyzer, MethodInfo methodInfo, ImportHandler importHandler) {
        String[] stringArray;
        this.classAnalyzer = classAnalyzer;
        this.imports = importHandler;
        this.minfo = methodInfo;
        this.methodName = methodInfo.getName();
        this.methodType = Type.tMethod(methodInfo.getType());
        boolean bl = this.isConstructor = this.methodName.equals("<init>") || this.methodName.equals("<clinit>");
        if (methodInfo.getBytecode() != null) {
            this.code = methodInfo.getBytecode();
        }
        if ((stringArray = methodInfo.getExceptions()) == null) {
            this.exceptions = new Type[0];
        } else {
            int n = stringArray.length;
            this.exceptions = new Type[n];
            int n2 = 0;
            while (n2 < n) {
                this.exceptions[n2] = Type.tClass(stringArray[n2]);
                ++n2;
            }
        }
        if (methodInfo.isSynthetic() || this.methodName.indexOf(36) != -1) {
            this.synth = new SyntheticAnalyzer(methodInfo, true);
        }
    }
}

