/*
	Copyright (c) 2012 Cycling '74

	Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
	and associated documentation files (the "Software"), to deal in the Software without restriction, 
	including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
	and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
	subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all copies 
	or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
	INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
	WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
	OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

// hotbits - real random numbers
// generated by the beta decay of Krypton-85
// learn more at http://www.fourmilab.ch/hotbits
//
// bbn 2004.03.18

import com.cycling74.max.*;
import java.net.*;
import java.io.*;

public class hotbits extends MaxObject {

	int bufferLength = 256, currentLength = 0;
    byte[] buffer;
    int bufptr = -1;

    public hotbits(Atom args[]) {
		declareOutlets(new int[]{DataTypes.ALL, DataTypes.ALL});
		if (args.length > 0) 
			if (args[0].isInt()) 
				if (args[0].getInt() > 0)
					bufferLength = args[0].getInt(); 
        buffer = new byte[bufferLength];
		try {
			fillBuffer();
		} catch (IOException e) {
			error("hotbits: can't connect to the hotbits server");
		}
    }

    private void fillBuffer() throws java.io.IOException {
		try {
			URL u = new URL("http://www.fourmilab.ch/cgi-bin/uncgi/Hotbits?nbytes=128&fmt=bin");
			InputStream s = u.openStream();
			currentLength = 0;
			int l;
			while ((l = s.read()) != -1) {
				buffer[currentLength++] = (byte)l;
			}
			s.close();
			bufptr = 0;
		} catch (IOException e) {
			error("hotbits: can't connect to the hotbits server");
			throw new IOException("can't connect to the hotbits server");
		}
    }

    private byte nextByte() throws java.io.IOException {
		synchronized (buffer) {
			if (bufptr < 0 || bufptr >= currentLength) {
				fillBuffer();
			}
			return buffer[bufptr++];
		}
    }
	
	public void bang() {
		try {
			outlet(0, nextByte());
			outlet(1, currentLength - bufptr);
		} catch (IOException e) {
			//nada
		}
	}

}